/***************************************************************************************************/
/**
  \mainpage 
  
  \n Copyright (c) 2008 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief      The main intention within this code example is to demonstrate the capability \n
              of Zen core (Z0) to emulate a PWM module without taking CPU resources      \n
              from Z1 core. A Multi-thread scheduler has been added to this example code \n
              to handle and show to customer the operation of the emulated PWM driver.
  \author     Freescale Semiconductor
  \author     R01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  
  \version    1.0
  \date       4/14/2008
  
 The MPC5510 IOP Library is a set of basic software drivers that emulate functionality   \n
 that has not been implemented in hardware. The intention is to provide customers with a \n
 software framework together with typical use cases to get them started on using the IOP \n
 very quickly and confidently. The drivers can be qualified as "high quality example code"\n
 that customers can build upon.
  
  DISCLAIMER: 
  
  *** Services performed by FREESCALE in this matter are performed AS IS and without any warranty. 
  CUSTOMER retains the final decision relative to the total design and functionality of the end product. 
  FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project. 
  FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, implied 
  warranty of merchantability or fitness for a particular purpose on any hardware, software ore advise 
  supplied to the project by FREESCALE, and or any product resulting from FREESCALE services . 
  In no event shall FREESCALE be liable for incidental or consequential damages arising out of this agreement. 
  CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone on account 
  of any damage, or injury, whether commercial, contractual, or tortuous, rising directly or indirectly as a 
  result of the advice or assistance supplied CUSTOMER in connection with product, services or goods supplied
  under this Agreement. ***
*/
/***************************************************************************************************/
#include "Derivative.h"
#include "Port.h"

/** Enable Interrupts */
#define ENABLE_INTERRUPTS    INTC_CPR_PRC0_PRI = 0;  \
                             asm(" wrteei 1")	    
 
/** This macro starts application running on Zen Core (Z0) */
#define RUN_PWM_ON_Z0     CRP.Z0VEC.R = (unsigned long)__start_p1
/** This macro starts application running on Main Core (Z1) */
#define RUN_PWM_ON_Z1     vfnPwm_Init(Pwm_ChannelConfig)

/* Prototype for PRC1 startup */
extern void __start_p1();
void TunningFlash(void);


void TunningFlash(void)
{
  FLASH.PFCRP0.R = 0x04025201;  	
                  /* ||||||||_ PFLIM &  BFEN = 0 
                     |||||||__ DPFEN & IPFEN = 0
                     ||||||___ WWSC = 0b11, RWSC = 0b010
                     |||||____ APC = 0b010
                     ||||_____ M0PFE = 1
                     |||______ 0x00
                     ||_______ ARB = 1
                     |________ LBCG = 0     
                  */
  FLASH.PFCRP1.R = 0x04025201;  	
}
                  

void main(void) 
{
  volatile int i = 0;

 TunningFlash();
 vfnInit_PLL();  /* Configure FLL to run up-to 64MHz */
 
 #if Z0_CORE == ON 
  /* Start the other core by writing CRP.Z0VEC.R */ 
  RUN_PWM_ON_Z0;
   
 #endif                  

  /* Loop forever */
  for (;;) 
  {
    i++;
  }
}



